#Paso 6
library(nnet, pos=4)

Datos1 <- Datos[Datos$Familia %in% c("Characidae","Curimatidae","Anostomidae"), ]
Datos1

#Paso 7
Table <- table(Datos1$Especie)
Table

#Paso 8
MLM.1 <- multinom(Especie ~ M2 + M6 + M8 + M9 + M12 + M13 + M15 + M16 + M17 + M21 + M22 + Boca, data=Datos1, trace=FALSE)
summary(MLM.1, cor=FALSE, Wald=TRUE)

#Paso 9
Datos2 <- factor(Datos1$Especie, exclude=NULL)
acierto <- sum(predict(MLM.1)==Datos2)/ dim(Datos1)[1]*100
acierto # porcentaje de acierto global

#Paso 10
MLM.2 <-stepwise(MLM.1, direction='backward/forward', criterion='AIC')
summary(MLM.2, cor=FALSE, Wald=TRUE)

#Paso 11
acierto <- sum(predict(MLM.2)==Datos2)/ dim(Datos1)[1]*100
acierto # porcentaje de acierto global

#Paso 12
MLM.3 <- multinom(Especie ~ M9 + M13 + M15, data=Datos1, trace=FALSE)
summary(MLM.3, cor=FALSE, Wald=TRUE)

#Paso 13
acierto <- sum(predict(MLM.3)==Datos2)/ dim(Datos1)[1]*100
acierto # porcentaje de acierto global

#Paso 14
pred <- data.frame(predict(MLM.3),Datos1$Especie)
names(pred)<-c("Prediccin","Real")
write.csv2(pred,file="Salida Cuadro XI.5-1.csv")

#Paso 15
write.csv2(coefficients(MLM.3),file="Salida Cuadro XI.5-2.csv")

#Paso 16
DatosNuevos<-read.csv2("Cuadro XI.5-1.V.csv",enc="latin1")
PredNuevos <- data.frame(predict(MLM.3,DatosNuevos),DatosNuevos$Especie)
names(PredNuevos)<-c("Prediccin","Real")
write.csv2(PredNuevos,file="Salida Cuadro XI.5-3.csv")

#Paso 17
t <- table(predict(MLM.3),Datos2)
t
tporc <- prop.table(t,2)*100
write.csv2(t,file="Salida Cuadro XI.5-4.csv")
write.csv2(tporc,file="Salida Cuadro XI.5-5.csv")



